import contextlib

with contextlib.suppress(ImportError):
    import wandb

import logging

from .base import Logger


class wandbLogger(Logger):
    def __init__(
        self,
        wandb_key,
        project_name,
        entity_name,
        run_name="logger",
        level=logging.INFO,
    ):
        super().__init__(run_name, level)
        self.wandb_key = wandb_key
        wandb.login(key=self.wandb_key)
        self.run = wandb.init(project=project_name, name=run_name, entity=entity_name)

    def info(self, msg, wandb_record):
        super().info(msg)
        wandb.log(wandb_record)
